<?php
class EmailNotification {
    private $admin_email;
    private $from_email;
    
    public function __construct($admin_email) {
        $this->admin_email = $admin_email;
        $this->from_email = 'noreply@' . $_SERVER['HTTP_HOST'];
    }
    
    public function sendEmail($subject, $message) {
        // Basic email headers
        $headers = array(
            'From: ' . $this->from_email,
            'Reply-To: ' . $this->from_email,
            'X-Mailer: PHP/' . phpversion(),
            'Content-Type: text/plain; charset=UTF-8'
        );
        
        // Convert headers array to string
        $headers_string = implode("\r\n", $headers);
        
        // Send email using PHP's mail() function
        return mail(
            $this->admin_email,
            $subject,
            $message,
            $headers_string
        );
    }
} 